#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

# 2D pole pisq reflektuje aktualni s tav hraciho pole
# indexuje se pisq[x][y]
pisq = [[0 for i in range(3)] for i in range(3)]
# pole obsahuje cislene hodnoty s nasledujicicim vyznamem:
# 0 = "_"
# 1 = "O"
# 2 = "X"


############################################################

# pokud nekdo vyhral, vrati ho (jeho cislo); jinak vrati 0
def who_won(ar):        
    if ((ar[0][0] != 0) and (ar[0][0] == ar[0][1]) and (ar[0][1] == ar[0][2])): return ar[0][0]
    if ((ar[1][0] != 0) and (ar[1][0] == ar[1][1]) and (ar[1][1] == ar[1][2])): return ar[1][0]
    if ((ar[2][0] != 0) and (ar[2][0] == ar[2][1]) and (ar[2][1] == ar[2][2])): return ar[2][0]

    if ((ar[0][0] != 0) and (ar[0][0] == ar[1][0]) and (ar[1][0] == ar[2][0])): return ar[0][0]
    if ((ar[0][1] != 0) and (ar[0][1] == ar[1][1]) and (ar[1][1] == ar[2][1])): return ar[0][1]
    if ((ar[0][2] != 0) and (ar[0][2] == ar[1][2]) and (ar[1][2] == ar[2][2])): return ar[0][2]

    if ((ar[0][0] != 0) and (ar[0][0] == ar[1][1]) and (ar[1][1] == ar[2][2])): return ar[0][0]
    if ((ar[2][0] != 0) and (ar[2][0] == ar[1][1]) and (ar[1][1] == ar[0][2])): return ar[2][0]    

    return 0

############################################################

# algoritmus minimax
def minimax(ar, hrac):
    # nejdrive zkontrolujeme, zda nekdo vyhral
    won = who_won(ar);
    if won > 0:
        if won == 2: won = -1   # pokud vyhral protihrac, hodnotime heho prohru zapornym koefecientem
        return won

    # pokud nikdo nevyhral, zanorime se
    res = 0
    for x in range(3):
        for y in range(3):
            if (ar[x][y] == 0):
                ar[x][y] = hrac
                if (hrac == 1):
                    res += minimax(ar, 2)
                if (hrac == 2):
                    res += minimax(ar, 1)
                ar[x][y] = 0
        
    return res

############################################################

def minimax_me(ar):
    # kontrola toho, jeslti nahodou nekdo nemuze primo vyhrat
    # pokud muzu vyhrat ja, dam na prislusne pole O a vyhraji
    # pokud muze vyhrat protihrac, dam na prislusne pole O, aby byla remiza
    for x in range(3):
        for y in range(3):
            if (ar[x][y] == 0):
                # kontrola me vyhry
                ar[x][y] = 1
                won = who_won(ar)
                ar[x][y] = 0
                if won == 1: return [x, y]

                # kontrola vyhry protihrace
                ar[x][y] = 2
                won = who_won(ar)
                ar[x][y] = 0
                if won == 2: return [x, y]                


    # nehrozi bezprostredni riziko, nebo moznost vyhry -> minimax
    # funkce minimax(...) vraci cislo, ktere udava pravdepodobnost me vyhry pri umisteni O na dane pole
    # -> chci umistit O tam, kde vysledk funkce minimax(...) je nejvetsi

    amax = -10000000 # toto je dostatecne mala hodnota pro piskvorky 3x3    
    for x in range(3):
        for y in range(3):
            if (ar[x][y] == 0):                
                # prazdna pozice -> obsadim ji a vyhodnotim, jakou mam sanci na vyhru
                ar[x][y] = 1
                cur = minimax(ar, 2)    # sanci si ulozim, pozici odobsadim a jedu dal
                ar[x][y] = 0

                # hledam maximalni navratovou hodnotu funkce
                if cur > amax:
                    amax = cur
                    res = [x, y]

    return res

############################################################

def platnyTah(x, y, symbol):
    """
    Ukolem teto funkce je vratit nenulovou hodnotu v pripade, ze tah byl uplne
    v poradku.

    Vstup: dvojice x, y souradnic, ktere jsou provedeny v tahu
           symbol 'X' nebo 'O' indikujici hrace (Karlik je 'O')

    Vystup: nenulova hodnota pokud je tah platny, jinak 0
    """

    if symbol == "O": pisq[x][y] = 1
    if symbol == "X": pisq[x][y] = 2

    if pisq[x][y] == 0:
      return 1
    else:
      return 0

############################################################

# vraci 1, pokud je hraci pole prazdne
def isempty(ar):
    for x in range(3):
        for y in range(3):
            if ar[x][y] != 0: return 0
    return 1

############################################################

def opravTah(x, y):
    """
    Ukolem teto funkce je vratit dvojici souradnic v pripade, ze tah nebyl
    vhodny (pozor, ted neresime platnost!) - tj. pomohl nam se uspesne
    priblizit k vyhre

    Vstup: dvojice x, y souradnic, ktere by mely byt provedeny v tahu

    Vystup: dvojice x, y, ktera bude pouzita pro tah. Pozor: pokud funkce
            vrati souradnice pro neplatny tah, bude zavolana opetovne a je tedy
            na vas, aby nedoslo k zacykleni!
    """

    # trocha empirie pro zrychleni programu:
    if isempty(pisq): return 1, 1

    # minimax
    pos = minimax_me(pisq)
    return pos[1], pos[0]
